<?php
// Setup PHP Enviropment
error_reporting(E_ALL & ~E_NOTICE);
// Define Contants
define('THIS_SCRIPT', 'requests');
// Cache Templates & Variables
// get special phrase groups
$phrasegroups = array(
	'microrequests',
	'postbit',
	'posting'
);
$specialtemplates = array(
    'smiliecache',
	'bbcodecache',
	'attachmentcache',
);
$globaltemplates = array(
    'microrequests_main',
	'microrequests_search',
    'microrequests_approve_requests',
    'microrequests_approve_requestsbit',
	'microrequests_browse_comment_bit',
    'microrequests_release_requests',
    'microrequests_release_requestsbit',
    'microrequests_categorybit',
    'microrequests_browse_category',
    'microrequests_browse_categorybit',
    'microrequests_latest_open',
    'microrequests_latest_approved',
    'microrequests_latest_released',
    'microrequests_latest_rejected',
    'microrequests_request_view',
    'microrequests_request_viewbit',
    'microrequests_positivebit',
    'microrequests_negativebit',
    'microrequests_addedit_request',
    'microrequests_membermenu',
    'microrequests_myrequestsbit',
    'microrequests_myrequests',
	'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
    'pm_quickreply',
    'editor_toolbar_on',
	'editor_clientscript',
	'editor_css',
	'editor_jsoptions_font',
	'editor_jsoptions_size',
    'editor_toolbar_off'
);
$actiontemplates = array();
// Include Globals
define('CDIR', getcwd());
require_once('./global.php');
require_once(DIR . '/includes/functions_editor.php');
require_once(DIR . '/includes/functions_wysiwyg.php');
require_once(DIR . '/includes/functions_newpost.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/class_bbcode.php');
require_once(DIR . '/includes/class_image.php');
require_once(DIR . '/includes/functions_misc.php');
require_once('./microrequests/includes/functions.php');

// Main Script
if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canuse'])){
    print_no_permission();
}
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'main';
}
if ($_REQUEST['do'] == 'main'){
  // Get Categories
  $categories = getCategories();
  $catid = 0;
  $limit = $vbulletin->options["microrequests_limit"];
  $latestopen = getLatestOpen($catid,$limit);
  $latestapproved = getLatestApproved($catid,$limit);
  $latestreleased = getLatestReleased($catid,$limit);
  $latestrejected = getLatestRejected($catid,$limit);
  if($vbulletin->options["microrequests_intro"])
  {
     ob_start();
     include('microrequests/introfiles/'.$vbulletin->options["microrequests_intro"].'');
     $intro = ob_get_contents();
     ob_end_clean();
  }
  $title = $vbulletin->options["microrequests_navbar"];
  $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] . ""=> $vbulletin->options['microrequests_navbar']));

  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('$searchform .= "' . fetch_template('microrequests_search') . '";');
  eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
  eval('print_output("' . fetch_template('microrequests_main') . '");');
}
// #######################################################################
// ######################## CATEGORY LISTING #############################
// #######################################################################
if ($_REQUEST['do'] == 'category')
{
    $categoryid = $vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
    if(!$categoryid)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
      eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
    // Get Category's details
    $get_categories = $vbulletin->db->query_read("
	                        SELECT * FROM " . TABLE_PREFIX . "microrequests_categories
	                        WHERE categoryid=$categoryid
	                        ");
    $this_category = $db->fetch_array($get_categories);
    if(!empty($this_category["introfile"]))
    {
       ob_start();
       include('microrequests/introfiles/'.$this_category["introfile"].'');
       $intro = ob_get_contents();
       ob_end_clean();
    }
    $totalrequests = 0;
    $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
    $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
    $totalrecords = $db->query_first("
                    SELECT COUNT(`requestid`) AS `totalrecords`
                    FROM `" . TABLE_PREFIX . "microrequests_requests`
                    WHERE categoryid=$categoryid
                    ");
    $recperpage = $vbulletin->options['microrequests_perpage'];
    sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $perpage, $recperpage, $recperpage);
    $limitlower = ($pagenumber - 1) * $perpage + 1;
    $limitupper = $pagenumber * $perpage;
    if ($limitupper > $totalrecords['totalrecords'])
    {
        $limitupper = $totalrecords['totalrecords'];
        if ($limitlower > $totalrecords['totalrecords'])
        {
            $limitlower = $totalrecords['totalrecords'] - $perpage;
        }
    }
    if ($limitlower <= 0)
    {
        $limitlower = 1;
    }
    $requests = $vbulletin->db->query_read("
	                        SELECT *
	                        FROM " . TABLE_PREFIX . "microrequests_requests AS requests
	                        WHERE categoryid=$categoryid
	                        ORDER BY requestid DESC
                            LIMIT " . ($limitlower - 1) . ", $perpage
	                        ");

    // Build Request Bits
    while ($request = $vbulletin->db->fetch_array($requests)){
	       $postdate = date($vbulletin->options['microrequests_dateformat'], strtotime($request['postdate']));
           $userid = getRecordById("user",$request["userid"],'userid');
           $status = getRecordById("microrequests_status",$request["status"],'statusid');
           $positive = getCountPositive($request["requestid"]);
           $negative = getCountNegative($request["requestid"]);
           //Change BG Classes
	       if ($totalrequests%2 == '0'){
	           $rowbg = "alt1";
	       } else {
	           $rowbg = "alt2";
	       }
 	       $totalrequests ++;
           $pagenav = construct_page_nav($pagenumber, $perpage, $totalrecords['totalrecords'], 'requests.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&categoryid='.$categoryid);
	       eval('$browsecategorybit .= "' . fetch_template('microrequests_browse_categorybit') . '";');
    }
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $request['title']));
    // Get Categories for Menu
    $categories = getCategories();
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_browse_category') . '");');
}
// #######################################################################
// ############################ VIEW REQUEST #############################
// #######################################################################
if ($_REQUEST['do'] == 'request'){

    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    if(!$requestid)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
      eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
    $isvisitor = 0;
    if(!$vbulletin->userinfo['userid']){
        $isvisitor = 1;
    }
    if($vbulletin->bf_ugp['microrequests']['canvote'])
    {
       $canvote = 1;
    } else {
       $canvote = 0;
    }
    // Get Positive Opinions
    $totalpositive = 0;
    $positive_get = $vbulletin->db->query_read("
                    SELECT * FROM " . TABLE_PREFIX . "microrequests_opinions
                    WHERE requestid=$requestid AND opinion='1'
	                ORDER BY opinionid ASC
	                ");
    while ($positive = $vbulletin->db->fetch_array($positive_get)){
           $voterpositive = getRecordById("user",$positive["userid"],'userid');
           $totalpositive ++;
	       eval('$positivebit .= "' . fetch_template('microrequests_positivebit') . '";');
    }
    // Get Negative Opinions
    $totalnegative = 0;
    $negative_get = $vbulletin->db->query_read("
                    SELECT * FROM " . TABLE_PREFIX . "microrequests_opinions
                    WHERE requestid=$requestid AND opinion='2'
	                ORDER BY opinionid ASC
	                ");
    while ($negative = $vbulletin->db->fetch_array($negative_get)){
           $voternegative = getRecordById("user",$negative["userid"],'userid');
           $totalnegative ++;
	       eval('$negativebit .= "' . fetch_template('microrequests_negativebit') . '";');
    }
    // Get Comments
    $totalcomments = 0;
    $comments = $vbulletin->db->query_read("
	                        SELECT *
	                        FROM " . TABLE_PREFIX . "microrequests_comments
	                        WHERE requestid=$requestid
	                        ORDER BY postdate DESC
	                        ");
    $owner = 0;
    while ($comment = $vbulletin->db->fetch_array($comments))
    {
	       $postdate = date($vbulletin->options['microrequests_dateformat'], $comment['postdate']);
           $userid = getRecordById("user",$comment["userid"],'userid');
           $commenttext = parseBbCode($comment["comment"]);
           // Who is the owner?
           $owner = $comment["userid"];
           // Check if active user is the owner and also has editing permissions,
           // or if he has moderator permissions
           $editperm = 0;
           if((($owner == $vbulletin->userinfo['userid']) AND ($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canedit"])) OR $permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])
           {
               // Check failed. Send him back
               $editperm = 1;
           }
           $delperm = 0;
           if((($owner == $vbulletin->userinfo['userid']) AND ($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["candelete"])) OR $permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])
           {
               // Check failed. Send him back
               $delperm = 1;
           }
           //Change BG Classes
	       if ($totalcomments%2 == '0'){
	           $rowbg = "alt1";
	       } else {
	           $rowbg = "alt2";
	       }
 	       $totalcomments ++;
	       eval('$browsecommentbit .= "' . fetch_template('microrequests_browse_comment_bit') . '";');
    }
    // Request Overall
    $request_details = $vbulletin->db->query_read("
                       SELECT * FROM " . TABLE_PREFIX . "microrequests_requests
                       WHERE requestid=$requestid
                       LIMIT 1
                       ");
    $request = $db->fetch_array($request_details);
    $postdate = date($vbulletin->options["microrequests_dateformat"], strtotime($request["postdate"]));
    $catid = getRecordById("microrequests_categories",$request["categoryid"],'categoryid');
    $userid = getRecordById("user",$request["userid"],'userid');
    $status = getRecordById("microrequests_status",$request["status"],'statusid');
    $membertext = parseBbCode($request["request"]);
    $admintext = parseBbCode($request["reply"]);
    eval('$requestviewbit .= "' . fetch_template('microrequests_request_viewbit') . '";');
    // Setup Comment Editor
    if(empty($vbulletin->bbcodecache)) $vbulletin->bbcodecache = array();
    $show['wysiwyg'] = ($setting['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
    $istyles_js = construct_editor_styles_js();
    $show['qr_require_click'] = 0;
    $editorid = construct_edit_toolbar('', 0, 'requests', ($setting['allow_smilies'] ? 1 : 0), 1, false, 'qr_pm');
    $messagearea = "
    <script type=\"text/javascript\">
    <!--
       var require_click = 0;
       var threaded_mode = 1;
       var is_last_page = false;
    // -->
    </script>
    $messagearea
    ";

    // Get Categories for Menu
    $categories = getCategories();
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] . "" => $vbphrase['microrequests_navbar'], '' => $request['title']));
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_request_view') . '");');
}
//  #######################################################################
//  ######################### Add / Edit Request ##########################
//  #######################################################################
if ($_REQUEST['do'] == 'addedit')
{
    // Check for access permission
    if(!($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canadd"]))
    {
         print_no_permission();
    }
    // First, let's clean input
    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    // Then, check if Request id exists or not
    if(!$requestid)
    {
       // Request id dosen't exists, let's populate empty or default values
       $request["categoryid"] = 0;
       $request["title"] = '';
       $request["status"] = 1;
       $request["postdate"] = date("YYYY-mm-dd");
       $userid= $vbulletin->userinfo['userid'];
       // Setup Editor
       if(empty($vbulletin->bbcodecache)) $vbulletin->bbcodecache = array();
       $show['wysiwyg'] = ($setting['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
       $istyles_js = construct_editor_styles_js();
       $show['qr_require_click'] = 0;
       $editorid = construct_edit_toolbar($request["request"], 0, '', ($setting['allow_smilies'] ? 1 : 0), 1, false, 'fe');
       $messagearea = "
       <script type=\"text/javascript\">
       <!--
          var require_click = false;
          var threaded_mode = 1;
          var is_last_page = false;
       // -->
       </script>
       $messagearea
       ";
       // Get Request Categories
       $categories = getRequestCategories($request["categoryid"]);
       // Get Request Statuses
       $statuses = getRequestStatuses($request["status"]);
    } else {
       // Find Request
       $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_requests WHERE requestid=$requestid LIMIT 1");
       $request = $db->fetch_array($qry);
       // Who is the owner?
       $owner = $request["userid"];
       // Check if active user is the owner or if he has moderator permissions
       if(($owner != $vbulletin->userinfo['userid']) AND (!($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])))
       {
           // Check failed. Send him back
           print_no_permission();
       }
       // Everything ok, let's get only data that can be editing
       $categoryid = $request["categoryid"];
       $title = $request["title"];
       $status = $request["status"];
       $userid= $request["userid"];
       // Setup Editor
       if(empty($vbulletin->bbcodecache)) $vbulletin->bbcodecache = array();
       $show['wysiwyg'] = ($setting['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
       $istyles_js = construct_editor_styles_js();
       $show['qr_require_click'] = 0;
       $editorid = construct_edit_toolbar($request["request"], 0, '', ($setting['allow_smilies'] ? 1 : 0), 1, false, 'fe');
       $messagearea = "
       <script type=\"text/javascript\">
       <!--
         var require_click = false;
         var threaded_mode = 1;
         var is_last_page = false;
       // -->
       </script>
       $messagearea
       ";
       // Get Categories
       $categories = getRequestCategories($request["categoryid"]);
       // Get Request Statuses
       $statuses = getRequestStatuses($request["status"]);
    }
    if(!$requestid)
    {
        $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_new_request']));
    } else {
        $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_edit_request']));
    }
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_addedit_request') . '");');
}
// #######################################################################
// ############################ SAVE NEW REQUEST #########################
// #######################################################################
if ($_REQUEST['do'] == 'saveupdate'){
    if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canadd']))
    {
         print_no_permission();
    }
    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    if($requestid != 0)
    {
       // Find Article
       $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_requests WHERE requestid=$requestid LIMIT 1");
       $request = $db->fetch_array($qry);
       // Who is the owner?
       $owner = $request["userid"];
       // Check if active user is the owner or if he has moderator permissions
       if(($owner != $vbulletin->userinfo['userid']) AND (!($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])))
       {
           // Check failed. Send him back
           print_no_permission();
       }
    }
    $vbulletin->input->clean_array_gpc('p', array(
   		'wysiwyg'       => TYPE_BOOL,
		'title'			=> TYPE_NOHTML,
        'message'		=> TYPE_STR,
        'reply'    		=> TYPE_STR,
        'categoryid'    => TYPE_UINT,
        'postdate'      => TYPE_STR,
        'userid'	    => TYPE_UINT,
        'status'	    => TYPE_UINT
	));
    // Get Values
	$title = $db->escape_string($vbulletin->GPC['title']);
    if($vbulletin->GPC['wysiwyg']) {
		$bodytext = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
    } else {
  	    $bodytext = $vbulletin->GPC['message'];
    }
	$bodytext = $db->escape_string($bodytext);
    $userid = $vbulletin->userinfo['userid'];
    $categoryid = $vbulletin->GPC['categoryid'];
    $postdate = date("Y-m-d");
    if($vbulletin->bf_ugp["microrequests"]["canmod"])
    {
       $status = $vbulletin->GPC['status'];
    } else {
       $status = 1;
    }
    $reply = $db->escape_string($vbulletin->GPC['reply']);
    if($requestid != 0)
    {
       $newrequest = false;
       // Update Request
       $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "microrequests_requests
                                 SET categoryid='$categoryid',
                                     title='$title',
                                     request='$bodytext',
                                     reply='$reply',
                                     status='$status',
                                     postdate='$postdate' WHERE requestid=$requestid");
    } else {
	   $newrequest = true;
       // Save New Request
       $vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "microrequests_requests
                                 SET categoryid='$categoryid',
                    			     userid='$userid',
                                     title='$title',
                                     request='$bodytext',
                                     reply='$reply',
                                     status='$status',
                                     postdate = '$postdate'");
       $requestid=$vbulletin->GPC['requestid'] = $db->insert_id();
    }
    if($userid<>$activeuser)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=approve";
    } else {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=myrequests";
    }
    eval(print_standard_redirect('microrequests_action_ok', true, true));
}
// #######################################################################
// ############################ SAVE NEW COMMENT #########################
// #######################################################################
if ($_REQUEST['do'] == 'savecomment'){
    if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canadd']))
    {
         print_no_permission();
    }
    $vbulletin->input->clean_array_gpc('p', array(
   		'wysiwyg'       => TYPE_BOOL,
        'message'		=> TYPE_STR,
        'userid'	    => TYPE_UINT
	));
    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    if($vbulletin->GPC['wysiwyg']) {
		$comment = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
    } else {
  	    $comment = $vbulletin->GPC['message'];
    }
	$comment = $db->escape_string($comment);
    $userid = $vbulletin->userinfo['userid'];
    $postdate = time();
    // Save New Comment
    $vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "microrequests_comments
                                 SET requestid='$requestid',
                                     userid='$userid',
                                     comment='$comment',
                                     postdate = '$postdate'");
    $commentid=$vbulletin->GPC['commentid'] = $db->insert_id();
    $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=request&requestid=".$requestid;
    eval(print_standard_redirect('microrequests_action_ok', true, true));
}
// #######################################################################
// ################################ VOTING ###############################
// #######################################################################
if ($_REQUEST['do'] == 'vote'){

    if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canvote']))
    {
         print_no_permission();
    }
    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    $opinion = $vbulletin->input->clean_gpc('r', 'opinion', TYPE_UINT);
    $userid = $vbulletin->userinfo['userid'];
    // Check for Vote
    $vote = $vbulletin->db->query_first("
	  	                SELECT * FROM " . TABLE_PREFIX . "microrequests_opinions
		                WHERE requestid = $requestid AND userid = '$userid'
		                LIMIT 1
	                    ");
    if(!$vote){
        // Save New Vote
	    $vbulletin->db->query_write("INSERT " . TABLE_PREFIX . "microrequests_opinions
				                     SET requestid = '$requestid',
                                     opinion = '$opinion',
                                     userid = '$userid'
   				                     ");
	    $getnewid=$vbulletin->GPC['opinionid'] = $db->insert_id();
        $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . 'do=request&requestid='.$requestid;
	    eval(print_standard_redirect('microrequests_action_ok', true, true));
    } else {
        $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . 'do=request&requestid='.$requestid;
	    eval(print_standard_redirect('microrequests_vote_rejected', true, true));
    }
}
// #######################################################################
// ##########################  DELETE REQUEST  ###########################
// #######################################################################
if ($_REQUEST['do'] == 'delete')
{
    $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    if($requestid != 0)
    {
       // Find Request
       $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_requests WHERE requestid=$requestid LIMIT 1");
       $request = $db->fetch_array($qry);
       // Who is the owner?
       $owner = $request["userid"];
       // Check if active user is the owner or if he has moderator permissions
       if(($owner != $vbulletin->userinfo['userid']) AND (!($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])))
       {
           // Check failed. Send him back
           print_no_permission();
       } else {
           $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "microrequests_requests WHERE requestid=$requestid LIMIT 1");
	       $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=myrequests";
	       eval(print_standard_redirect('microrequests_action_ok', true, true));
       }
    } else {
	       $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
	       eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
}
// #######################################################################
// ##########################  DELETE COMMENT  ###########################
// #######################################################################
if ($_REQUEST['do'] == 'deletecomment')
{
    $commentid = $vbulletin->input->clean_gpc('r', 'commentid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    if(!$commentid)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
      eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
    // Find Comment
    $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
    $comment = $db->fetch_array($qry);
    // Who is the owner?
    $owner = $comment["userid"];
    if((($owner == $vbulletin->userinfo['userid']) AND ($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["candelete"])) OR $permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])
    {
         $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
         $comment = $db->fetch_array($qry);
         $requestid = $comment["requestid"];
         $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
    } else {
         print_no_permission();
    }
	$vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=request&requestid=$requestid";
	eval(print_standard_redirect('microrequests_action_ok', true, true));
}
// #######################################################################
// ############################  EDIT COMMENT  ###########################
// #######################################################################
if ($_REQUEST['do'] == 'editcomment')
{
    $commentid = $vbulletin->input->clean_gpc('r', 'commentid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    if(!$commentid)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
      eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
    // Find Comment
    $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
    $comment = $db->fetch_array($qry);
    // Who is the owner?
    $owner = $comment["userid"];
    if((($owner == $vbulletin->userinfo['userid']) AND ($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canedit"])) OR $permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])
    {
         $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
         $comment = $db->fetch_array($qry);
         $requestid = $comment["requestid"];
         if(empty($vbulletin->bbcodecache)) $vbulletin->bbcodecache = array();
         $show['wysiwyg'] = ($setting['allow_bbcode'] ? is_wysiwyg_compatible() : 0);
         $istyles_js = construct_editor_styles_js();
         $show['qr_require_click'] = 0;
         $editorid = construct_edit_toolbar($comment["comment"], 0, '', ($setting['allow_smilies'] ? 1 : 0), 1, false, 'fe');
         $messagearea = "
         <script type=\"text/javascript\">
         <!--
           var require_click = 0;
           var threaded_mode = 1;
           var is_last_page = false;
         // -->
         </script>
         $messagearea
         ";
    } else {
         print_no_permission();
    }
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_edit_comment']));
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_edit_comment') . '");');
}
// #######################################################################
// ############################  UPDATE COMMENT  #########################
// #######################################################################
if ($_REQUEST['do'] == 'updatecomment')
{
    $commentid = $vbulletin->input->clean_gpc('r', 'commentid', TYPE_UINT);
    $activeuser = $vbulletin->userinfo['userid'];
    if(!$commentid)
    {
      $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=main";
      eval(print_standard_redirect('microrequests_invalid_data', true, true));
    }
    // Find Comment
    $qry = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "microrequests_comments WHERE id=$commentid LIMIT 1");
    $comment = $db->fetch_array($qry);
    // Who is the owner?
    $owner = $comment["userid"];
    if((($owner == $vbulletin->userinfo['userid']) AND ($permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canedit"])) OR $permissions["microrequests"] & $vbulletin->bf_ugp["microrequests"]["canmod"])
    {
         $vbulletin->input->clean_array_gpc('p', array(
   		    'wysiwyg'       => TYPE_BOOL,
            'message'		=> TYPE_STR,
            'userid'	    => TYPE_UINT
	     ));
         $requestid = $vbulletin->input->clean_gpc('r', 'requestid', TYPE_UINT);
         if($vbulletin->GPC['wysiwyg']) {
		    $comment = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
         } else {
  	        $comment = $vbulletin->GPC['message'];
         }
	     $comment = $db->escape_string($comment);
         // UPDATE Comment
         $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "microrequests_comments
                                      SET comment='$comment' WHERE id='$commentid'");
         $vbulletin->url="requests.php?" . $vbulletin->session->vars['sessionurl'] . "do=request&requestid=".$requestid;
         eval(print_standard_redirect('microrequests_action_ok', true, true));
    } else {
         print_no_permission();
    }
}
// #######################################################################
// ###########################  MY REQUESTS  #############################
// #######################################################################
if ($_REQUEST['do'] == 'myrequests')
{
    $totalrequests = 0;
    $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
    $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
    $memberid = $vbulletin->userinfo[userid];
    $totalrecords = $db->query_first("
                    SELECT COUNT(`requestid`) AS `totalrecords`
                    FROM `" . TABLE_PREFIX . "microrequests_requests`
                    WHERE userid = $memberid
                    ");
    $recperpage = $vbulletin->options['microrequests_perpage'];
    sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $perpage, $recperpage, $recperpage);
    $limitlower = ($pagenumber - 1) * $perpage + 1;
    $limitupper = $pagenumber * $perpage;
    if ($limitupper > $totalrecords['totalrecords'])
    {
        $limitupper = $totalrecords['totalrecords'];
        if ($limitlower > $totalrecords['totalrecords'])
        {
            $limitlower = $totalrecords['totalrecords'] - $perpage;
        }
    }
    if ($limitlower <= 0)
    {
        $limitlower = 1;
    }
    $myrequests_get = $vbulletin->db->query_read("
	                          SELECT *
	                          FROM " . TABLE_PREFIX . "microrequests_requests
	                          WHERE userid = $memberid
	                          ORDER BY postdate DESC
                              LIMIT " . ($limitlower - 1) . ", $perpage
	                          ");

    while ($request = $vbulletin->db->fetch_array($myrequests_get)){
	       $postdate = date($vbulletin->options['microrequests_dateformat'], strtotime($request['postdate']));
           $catid = getRecordById("microrequests_categories",$request["categoryid"],'categoryid');
           $status = getRecordById("microrequests_status",$request["status"],'statusid');
           $positive = getCountPositive($request["requestid"]);
           $negative = getCountNegative($request["requestid"]);
           //Change BG Classes
	       if ($totalrequests%2 == '0'){
	           $rowbg = "alt1";
	       } else {
	           $rowbg = "alt2";
	       }
 	       $totalrequests ++;
           $pagenav = construct_page_nav($pagenumber, $perpage, $totalrecords['totalrecords'], 'requests.php?' . $vbulletin->session->vars['sessionurl'] . 'do=myrequests');
	       eval('$myrequestsbit .= "' . fetch_template('microrequests_myrequestsbit') . '";');
    }
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_my_requests']));
    // Get Categories for Menu
    $categories = getCategories();
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_myrequests') . '");');
}
// #######################################################################
// #########################  OPEN REQUESTS  #############################
// #######################################################################
if ($_REQUEST['do'] == 'approve')
{
    if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canmod']))
    {
         print_no_permission();
    }
    $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
    $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
    // Get Open Requests
    $totalrecords = $db->query_first("
                    SELECT COUNT(`requestid`) AS `totalrecords`
                    FROM `" . TABLE_PREFIX . "microrequests_requests`
                    WHERE status='1'
                    ORDER BY postdate ASC
                    ");
    $recperpage = $vbulletin->options['microrequests_perpage'];
    sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $perpage, $recperpage, $recperpage);
    $limitlower = ($pagenumber - 1) * $perpage + 1;
    $limitupper = $pagenumber * $perpage;
    if ($limitupper > $totalrecords['totalrecords'])
    {
        // Too many for upper limit
        $limitupper = $totalrecords['totalrecords'];
        if ($limitlower > $totalrecords['totalrecords'])
        {
            // Too many for lower limit
            $limitlower = $totalrecords['totalrecords'] - $perpage;
        }
    }
    if ($limitlower <= 0)
    {
        // Can't have negative or null lower limit
        $limitlower = 1;
    }
    $open_get = $vbulletin->db->query_read("
	              SELECT *
	              FROM " . TABLE_PREFIX . "microrequests_requests
	              WHERE status = '1'
	              ORDER BY postdate ASC
                  LIMIT " . ($limitlower - 1) . ", $perpage
	              ");
    $totalopen = 0;
    while ($open = $vbulletin->db->fetch_array($open_get)){
           $postdate = date($vbulletin->options['microrequests_dateformat'], strtotime($open['postdate']));
           $userid = getRecordById("user",$open["userid"],'userid');
           $positive = getCountPositive($open["requestid"]);
           $negative = getCountNegative($open["requestid"]);
           $catid = getRecordById("microrequests_categories",$open["categoryid"],'categoryid');
           //Change BG Classes
	       if ($totalopen%2 == '0'){
	           $rowbg = "alt1";
	       } else {
	           $rowbg = "alt2";
	       }
 	       $totalopen ++;
           $pagenav = construct_page_nav($pagenumber, $perpage, $totalrecords['totalrecords'], 'requests.php?' . $vbulletin->session->vars['sessionurl'] . 'do=approve');
	       eval('$openbit .= "' . fetch_template('microrequests_approve_requestsbit') . '";');
    }
    // Get Categories for Menu
    $categories = getCategories();
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_open_requests']));
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_approve_requests') . '");');
}
// #######################################################################
// #########################  APPROVED REQUESTS  #########################
// #######################################################################
if ($_REQUEST['do'] == 'release')
{
    if(!($permissions['microrequests'] & $vbulletin->bf_ugp['microrequests']['canmod']))
    {
         print_no_permission();
    }
    $perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
    $pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
    // Get Approved Requests
    $totalrecords = $db->query_first("
                    SELECT COUNT(`requestid`) AS `totalrecords`
                    FROM `" . TABLE_PREFIX . "microrequests_requests`
                    WHERE status='2'
                    ORDER BY postdate ASC
                    ");
    $recperpage = $vbulletin->options['microrequests_perpage'];
    sanitize_pageresults($totalrecords['totalrecords'], $pagenumber, $perpage, $recperpage, $recperpage);
    $limitlower = ($pagenumber - 1) * $perpage + 1;
    $limitupper = $pagenumber * $perpage;
    if ($limitupper > $totalrecords['totalrecords'])
    {
        // Too many for upper limit
        $limitupper = $totalrecords['totalrecords'];
        if ($limitlower > $totalrecords['totalrecords'])
        {
            // Too many for lower limit
            $limitlower = $totalrecords['totalrecords'] - $perpage;
        }
    }
    if ($limitlower <= 0)
    {
        // Can't have negative or null lower limit
        $limitlower = 1;
    }
    $approved_get = $vbulletin->db->query_read("
	              SELECT *
	              FROM " . TABLE_PREFIX . "microrequests_requests
	              WHERE status = '2'
	              ORDER BY postdate ASC
                  LIMIT " . ($limitlower - 1) . ", $perpage
	              ");
    $totalopen = 0;
    while ($approved = $vbulletin->db->fetch_array($approved_get)){
           $postdate = date($vbulletin->options['microrequests_dateformat'], strtotime($approved['postdate']));
           $userid = getRecordById("user",$approved["userid"],'userid');
           $positive = getCountPositive($approved["requestid"]);
           $negative = getCountNegative($approved["requestid"]);
           $catid = getRecordById("microrequests_categories",$approved["categoryid"],'categoryid');
           //Change BG Classes
	       if ($totalopen%2 == '0'){
	           $rowbg = "alt1";
	       } else {
	           $rowbg = "alt2";
	       }
 	       $totalopen ++;
           $pagenav = construct_page_nav($pagenumber, $perpage, $totalrecords['totalrecords'], 'requests.php?' . $vbulletin->session->vars['sessionurl'] . 'do=release');
	       eval('$approvedbit .= "' . fetch_template('microrequests_release_requestsbit') . '";');
    }
    // Get Categories for Menu
    $categories = getCategories();
    $navbits = construct_navbits(array("requests.php?" . $vbulletin->session->vars['sessionurl'] => $vbphrase['microrequests_navbar'], '' => $vbphrase['microrequests_approved_requests']));
    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$membermenu .= "' . fetch_template('microrequests_membermenu') . '";');
    eval('print_output("' . fetch_template('microrequests_release_requests') . '");');
}
?>
